<?php
if (!defined('ADDFUNDS')) {
    http_response_code(404);
    die();
}

// বিকাশ API কনফিগারেশন
$bkash_username = htmlspecialchars($methodExtras["username"]);
$bkash_password = htmlspecialchars($methodExtras["password"]);
$bkash_app_key = htmlspecialchars($methodExtras["app_key"]);
$bkash_app_secret = htmlspecialchars($methodExtras["app_secret_key"]);

// বিকাশ পেমেন্ট প্রসেসিং শুরু
try {
    // বিকাশ টোকেন তৈরি (একটি উদাহরণস্বরূপ)
    $tokenUrl = "https://tokenized.pay.bka.sh/v1.2.0-beta/token/grant";  // লাইভ URL: https://pay.bka.sh
    $headers = [
        "Content-Type: application/json",
        "username: $bkash_username",
        "password: $bkash_password"
    ];

    $data = [
        "app_key" => $bkash_app_key,
        "app_secret" => $bkash_app_secret
    ];

    // CURL দিয়ে টোকেন রিকোয়েস্ট পাঠানো
    $ch = curl_init($tokenUrl);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($ch);
    curl_close($ch);

    $responseArray = json_decode($response, true);

    // টোকেন সফলভাবে পাওয়া গেলে
    if (isset($responseArray['id_token'])) {
        $idToken = $responseArray['id_token'];
        echo "bKash payment initiated successfully. Token: $idToken";
    } else {
        throw new Exception("bKash Token generation failed: " . $responseArray['errorMessage']);
    }
} catch (Exception $e) {
    die("Error in bKash payment: " . $e->getMessage());
}
?>